// SDKDemo.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "PrinterSettings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSDKDemoApp

BEGIN_MESSAGE_MAP(CSDKDemoApp, CWinApp)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSDKDemoApp construction

CSDKDemoApp::CSDKDemoApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSDKDemoApp object

CSDKDemoApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSDKDemoApp initialization

BOOL CSDKDemoApp::InitInstance()
{
	TCHAR DLLPath[MAX_PATH];

	AfxEnableControlContainer();

	GetSystemDirectory(DLLPath, MAX_PATH);
	_tcscat_s(DLLPath, MAX_PATH, _T("\\MagAPI.DLL"));

	HINSTANCE hLib = LoadLibrary(DLLPath);
	if (hLib == NULL)
	{
		CString temp_string = _T("Cannot Load ");
		AfxMessageBox(temp_string + DLLPath);
	}

	else
	{
		CMainSheet		 *MainSheet   = new CMainSheet(MSGBOX_TITLE);
		CPrinterSettings *PrinterPage = new CPrinterSettings;

		//Save library instance for SDK DLL
		MainSheet->hLib = hLib;

		//Add the Printer Settings page and make it modal
		MainSheet->AddPage(PrinterPage);
		MainSheet->DoModal();

		FreeLibrary(hLib);

		delete MainSheet;
		delete PrinterPage;
	}

	//Since the dialog has been closed, return FALSE so that we exit the
	//application, rather than start the application's message pump.
	return FALSE;
}